<?php
class ControllerExtensionPaymentlinkify extends Controller {
    private $error = array();
    
    public function install(){
        
        $query = $this->db->query(
            'CREATE TABLE IF NOT EXISTS ' . DB_PREFIX . 'linkify_transfers ('.
            'linked TINYINT(1) DEFAULT NULL COMMENT "NULL when transfer has been unlinked from the order. 1 when transfer is assigned to the order", '.
            'linkify_transfer_hashid VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL, '.
            'opencart_order_id INT(11) NOT NULL, '.
            'amount INT(11) NOT NULL, '.
            'creation_date DATETIME NOT NULL, '.
            'last_update_date DATETIME NOT NULL, '.
            'UNIQUE KEY (linked, linkify_transfer_hashid))'
        );
    }

	public function index() {
        $this->load->language('extension/payment/linkify');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_linkify', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['merchantid'])) {
            $data['error_merchantid'] = $this->error['merchantid'];
        } else {
            $data['error_merchantid'] = '';
        }

        if (isset($this->error['secret'])) {
            $data['error_secret'] = $this->error['secret'];
        } else {
            $data['error_secret'] = '';
        }

        if (isset($this->error['status_logic'])) {
            $data['error_status_logic'] = $this->error['status_logic'];
        } else {
            $data['error_status_logic'] = '';
        }


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/linkify', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/payment/linkify', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		if (isset($this->request->post['linkify_merchantid'])) {
			$data['payment_linkify_merchantid'] = $this->request->post['payment_linkify_merchantid'];
		} else {
			$data['payment_linkify_merchantid'] = $this->config->get('payment_linkify_merchantid');
		}

        if (isset($this->request->post['payment_linkify_secret'])) {
                $data['payment_linkify_secret'] = $this->request->post['payment_linkify_secret'];
        } else {
                $data['payment_linkify_secret'] = $this->config->get('payment_linkify_secret');
        }

        if (isset($this->request->post['payment_linkify_pending_status_ids'])) {
            $data['payment_linkify_pending_status_ids'] = $this->request->post['payment_linkify_pending_status_ids'];
        } else {
            $data['payment_linkify_pending_status_ids'] = explode(",",$this->config->get('payment_linkify_pending_status_ids'));
        }

        if (isset($this->request->post['payment_linkify_partial_status_ids'])) {
            $data['payment_linkify_partial_status_ids'] = $this->request->post['payment_linkify_partial_status_ids'];
        } else {
            $data['payment_linkify_partial_status_ids'] = explode(",",$this->config->get('payment_linkify_partial_status_ids'));
        }

        if (isset($this->request->post['payment_linkify_completed_status_ids'])) {
            $data['payment_linkify_completed_status_ids'] = $this->request->post['payment_linkify_completed_status_ids'];
        } else {
            $data['payment_linkify_completed_status_ids'] = explode(",",$this->config->get('payment_linkify_completed_status_ids'));
        }

        if (isset($this->request->post['payment_linkify_send_client_notification_on_pending'])) {
            $data['payment_linkify_send_client_notification_on_pending'] = $this->request->post['payment_linkify_send_client_notification_on_pending'];
        } else {
            $data['payment_linkify_send_client_notification_on_pending'] = $this->config->get('payment_linkify_send_client_notification_on_pending');
        }

        if (isset($this->request->post['payment_linkify_send_client_notification_on_partial'])) {
            $data['payment_linkify_send_client_notification_on_partial'] = $this->request->post['payment_linkify_send_client_notification_on_partial'];
        } else {
            $data['payment_linkify_send_client_notification_on_partial'] = $this->config->get('payment_linkify_send_client_notification_on_partial');
        }

        if (isset($this->request->post['payment_linkify_send_client_notification_on_completed'])) {
            $data['payment_linkify_send_client_notification_on_completed'] = $this->request->post['payment_linkify_send_client_notification_on_completed'];
        } else {
            $data['payment_linkify_send_client_notification_on_completed'] = $this->config->get('payment_linkify_send_client_notification_on_completed');
        }

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_linkify_geo_zone_id'])) {
			$data['payment_linkify_geo_zone_id'] = $this->request->post['payment_linkify_geo_zone_id'];
		} else {
			$data['payment_linkify_geo_zone_id'] = $this->config->get('payment_linkify_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_linkify_status'])) {
            $data['payment_linkify_status'] = $this->request->post['payment_linkify_status'];
        } else {
            $data['payment_linkify_status'] = $this->config->get('payment_linkify_status');
        }
		
		if (isset($this->request->post['payment_linkify_sort_order'])) {
			$data['payment_linkify_sort_order'] = $this->request->post['payment_linkify_sort_order'];
		} else {
			$data['payment_linkify_sort_order'] = $this->config->get('payment_linkify_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['footer'] = $this->load->controller('common/footer');
		$data['column_left'] = $this->load->controller('common/column_left');


		$this->response->setOutput($this->load->view('extension/payment/linkify', $data));
	}

	private function validate() {

		if (!$this->user->hasPermission('modify', 'extension/payment/linkify')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_linkify_merchantid']) {
			$this->error['merchantid'] = $this->language->get('error_merchantid');
		}

        if (!$this->request->post['payment_linkify_secret']) {
            $this->error['secret'] = $this->language->get('error_secret');
        }

        //Validate the pending, partial and complete status  
        $config_ids_by_status = array(
            "pending" => $this->request->post['payment_linkify_pending_status_ids'],
            "partial" => $this->request->post['payment_linkify_partial_status_ids'],
            "completed" => $this->request->post['payment_linkify_completed_status_ids']
        );

        //Extract lanes per status until -1 is found
        foreach($config_ids_by_status as $status => $config_ids){
            for($i=0; $i < count($config_ids); $i++){
                if($config_ids[$i] == -1){
                    $config_ids_by_status[$status] = array_slice($config_ids, 0, $i);
                    break;
                }
            }
        }

        //Requires minimun one config per status, and that in all status there are the same amount of lane
        if(sizeof($config_ids_by_status["pending"]) == 0 || 
            sizeof($config_ids_by_status["pending"]) != sizeof($config_ids_by_status["partial"]) || 
            sizeof($config_ids_by_status["pending"]) != sizeof($config_ids_by_status["completed"])){
                $this->error['status_logic'] = $this->language->get('error_status_logic_1');
        }else{
            
            //An oc_status (cancelled, reversal, etc..) cant be repeated in different status row (pending, partial, completed)
            $used_statuses = array();
            $error = false;
            foreach($config_ids_by_status as $status => $config_ids){
                $curr_statuses = array();
                for($i = 0; $i < count($config_ids); $i++){
                    if($config_ids[$i] == -1){
                        $config_ids_by_status[$status] = array_slice($config_ids, 0, $i);
                        break;
                    }
                    if(in_array($config_ids[$i], $used_statuses)){
                        $error = true;
                        $this->error['status_logic'] = $this->language->get('error_status_logic_2');
                    }
                    $curr_statuses[] = $config_ids[$i];
                }
                $used_statuses = array_merge($used_statuses, $curr_statuses);
            }
            //Update the values to store csv in the database
            if(!$error){
                foreach($config_ids_by_status as $status => $config_ids){
                    $this->request->post['payment_linkify_'.$status.'_status_ids'] = implode(",", $config_ids);
                }
            }
            
        }

        return !$this->error;
	}
}
?>
